library(reshape2)
library(ggplot2)
library(ggpubr)
library(viridisLite)
library(viridis)
library(cowplot)
args=commandArgs(T)
file1 <- args[1]
file2 <- args[2]
file3 <- args[3]
data1 <- read.table(file1,header = T)
data2 <- read.table(file2,header = T)
a <- data1$length
b <- (data1$A+data2$A)/1000000
c <- (data1$U+data2$U)/1000000
d <- (data1$C+data2$C)/1000000
e <- (data1$G+data2$G)/1000000
test <- data.frame(a,b,c,d,e)
colnames(test) <- c("length","A","U","C","G")
count <- test

yanse1 <- c("#E7308F","#F0812C","#64BD47","#3877BB")

mydata <- melt(count,id.vars = "length",variable.name = "type",value.name = "counts")

p <- ggplot(data=mydata,aes(length,counts,fill=type))+geom_bar(stat="identity",position = "stack",color='NA')+theme_bw()+theme_classic()+scale_y_continuous(limits=c(0,12),expand = c(0,0))+xlim(17,29)+scale_fill_manual(values = yanse1)
p
count$counts <- count$A+count$U+count$C+count$G
a <- data.frame(c("bA","aU","cC","dG"),c(sum(count$A)/sum(count$counts),sum(count$U)/sum(count$counts),sum(count$C)/sum(count$counts),sum(count$G)/sum(count$counts)))
colnames(a) <- c("type","percentage")
a$percentage <- round(a$percentage,2)
yanse=c("#F0812C","#E7308F","#64BD47","#3877BB")
mylable <- paste(a$type,'(',a$percentage*100,'%',')',sep = '')
q <- ggpie(a,'percentage',fill='type',legend="NA",label = mylable,lab.pos = 'out',lab.font = c(4,'white'),color='NA',palette =yanse)

p <- ggdraw() +draw_plot(p+theme(legend.justification = "bottom"),0,0,1,1)+draw_plot(q,0.5,0.52,0.5,0.4)
p

pdf(file3,width = 6,height = 6)
p
dev.off()
